"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.errorLogger = exports.infoLogger = void 0;
const winston_1 = __importStar(require("winston"));
const date_fns_1 = require("date-fns");
const winston_mongodb_1 = require("winston-mongodb");
const winston_daily_rotate_file_1 = __importDefault(require("winston-daily-rotate-file"));
const chalk_1 = __importDefault(require("chalk"));
const mongoUri = process.env.MONGO_URL
    ? process.env.MONGO_URL + `/AimHospitality`
    : "mongodb://127.0.0.1:27017/AimHospitality";
const consoleLogFormat = winston_1.format.combine(winston_1.format.timestamp(), winston_1.format.printf(({ level, message, timestamp }) => {
    let ldate = (0, date_fns_1.format)(timestamp, "dd-MM-yyyy hh:mm:ss aa");
    let levell = chalk_1.default.red.inverse(` ${level.toUpperCase()} `);
    let con = JSON.parse(message);
    let disM = `"${chalk_1.default.red(con.msg)}" in ${con.path}`;
    return `[${ldate}] ${levell} ${chalk_1.default.gray.bold(con.id)}: ${disM}.`;
}));
const errorFileLogFormat = winston_1.format.combine(winston_1.format.json(), winston_1.format.timestamp(), winston_1.format.prettyPrint(), winston_1.format.printf(({ level, message, timestamp }) => {
    let ldate = (0, date_fns_1.format)(timestamp, "dd-MM-yyyy hh:mm:ss aa");
    let con = JSON.parse(message);
    let disM = `"${con.msg}" in ${con.path}`;
    return `[${ldate}] [${level.toUpperCase()}] ${con.id}: ${disM}.`;
}));
const infoFileLogFormat = winston_1.format.combine(winston_1.format.json(), winston_1.format.timestamp(), winston_1.format.prettyPrint(), winston_1.format.printf(({ level, message, timestamp }) => {
    let ldate = (0, date_fns_1.format)(timestamp, "dd-MM-yyyy hh:mm:ss aa");
    let con = JSON.parse(message);
    return `[${ldate}] [${level.toUpperCase()}] ${con.id}: ${con.path}.`;
}));
exports.infoLogger = (0, winston_1.createLogger)({
    levels: winston_1.default.config.npm.levels,
    format: winston_1.format.combine(winston_1.format.json(), winston_1.format.timestamp(), winston_1.format.prettyPrint()),
    transports: [
        new winston_daily_rotate_file_1.default({
            format: infoFileLogFormat,
            filename: "./logs/info_%DATE%.log",
            datePattern: "DD_MM_YYYY",
            zippedArchive: true,
            maxSize: "20m",
            level: "info",
        }),
        new winston_mongodb_1.MongoDB({
            db: mongoUri,
            collection: "logs",
        }),
    ],
});
exports.errorLogger = (0, winston_1.createLogger)({
    format: winston_1.format.combine(winston_1.format.json(), winston_1.format.timestamp(), winston_1.format.prettyPrint()),
    transports: [
        new winston_1.transports.Console({ format: consoleLogFormat, level: "error" }),
        new winston_daily_rotate_file_1.default({
            format: errorFileLogFormat,
            filename: "./logs/errors_%DATE%.log",
            datePattern: "DD_MM_YYYY",
            zippedArchive: true,
            maxSize: "20m",
            level: "error",
        }),
        new winston_mongodb_1.MongoDB({
            db: mongoUri,
            collection: "logs",
        }),
    ],
});
