"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("./logger");
const nanoid_1 = require("nanoid");
const nanoid = (0, nanoid_1.customAlphabet)((process.env.NANOID || "abcdefghijklmnopqrstuvwxyz1234567890"), 21);
function errorHandler(error, req, res, next) {
    const statusCode = error.status || 500;
    const Emessage = error.message || "An unexpected error occurred";
    /* logger.error(
      JSON.stringify({
        success: false,
        msg: Emessage,
        msgx: `[ERROR]: ${Emessage} in ${req.method}${req.url} with Status Code ${statusCode}`,
        status: statusCode,
        data: {},
      })
    ); */
    logger_1.errorLogger.error(JSON.stringify({
        success: false,
        id: nanoid(),
        msg: Emessage,
        method: req.method,
        url: req.method,
        path: `${req.method}${req.url}`,
        status: statusCode,
        stack: error.stack,
    }));
    res.status(statusCode).json({
        success: false,
        msg: Emessage,
        msgx: `[ERROR]: ${Emessage} in ${req.method}${req.url} with Status Code ${statusCode}`,
        status: statusCode,
        data: {},
        stack: process.env.NODE_ENV === "development" ? error.stack : {},
    });
}
exports.default = errorHandler;
