"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors = require("cors");
const morgan_1 = __importDefault(require("morgan"));
const path_1 = __importDefault(require("path"));
const logger_1 = require("./middlewares/logger");
require("dotenv").config();
const errorHandler_1 = __importDefault(require("./middlewares/errorHandler"));
const auth_1 = __importDefault(require("./routes/auth"));
const users_1 = __importDefault(require("./routes/users"));
const admin_1 = __importDefault(require("./routes/admin"));
const nanoid_1 = require("nanoid");
const nanoid = (0, nanoid_1.customAlphabet)((process.env.NANOID || "abcdefghijklmnopqrstuvwxyz1234567890"), 21);
const app = (0, express_1.default)();
const PORT = process.env.PORT || 3000;
app.use(express_1.default.static(path_1.default.join(__dirname, 'public')));
app.use(cors());
app.use((0, morgan_1.default)(process.env.MORGAN_FORMAT || ":method :url :status :response-time ms", {
    stream: {
        write: (message) => {
            let [method, url, status, responseTime] = message.split(" ");
            const logObject = {
                method,
                url,
                id: nanoid(),
                path: `${method}${url}`,
                status,
                responseTime: `${responseTime} ms`,
            };
            if (status != "500" &&
                url != "/api/auth/auth" &&
                !url.startsWith("/api/admin/logs")) {
                logger_1.infoLogger.info(JSON.stringify(logObject));
            }
        },
    },
}));
app.use(express_1.default.json({ limit: "10mb" }));
app.use("/api/auth", auth_1.default);
app.use("/api/users", users_1.default);
app.use("/api/admin", admin_1.default);
app.get('*', (req, res) => {
    res.sendFile(path_1.default.join(__dirname, 'public', 'index.html'));
});
app.get("/api", (req, res, next) => {
    try {
        return res.json({ success: true, msg: "lala", data: {} });
    }
    catch (error) {
        return next(error);
    }
});
app.use(errorHandler_1.default);
app.listen(PORT, () => {
    console.log(`Running on localhost:` + PORT);
});
