"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.postFeedback = postFeedback;
const jwt = require("jsonwebtoken");
const md5 = require("md5");
const users_dto_1 = require("../dtos/users.dto");
const db_1 = require("../models/db");
function postFeedback(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        try {
            if (!((_c = (_b = (_a = req === null || req === void 0 ? void 0 : req.headers) === null || _a === void 0 ? void 0 : _a.authorization) === null || _b === void 0 ? void 0 : _b.split(" ")) === null || _c === void 0 ? void 0 : _c[1])) {
                throw new Error("auth header is missing or error with auth header or wrong token");
            }
            const db = yield (0, db_1.connectToDatabase)();
            const collection = db.collection("feedback");
            const feedback = yield users_dto_1.postFeedbackVS.validate(Array.isArray(req.body) ? req.body : [req.body]);
            const feedEmail = feedback === null || feedback === void 0 ? void 0 : feedback.map(q => q.email);
            const feedPhone = feedback === null || feedback === void 0 ? void 0 : feedback.map(q => q.phone);
            const existingFeedback = yield collection.findOne({
                $or: [{ email: { $in: feedEmail } }, { phone: { $in: feedPhone } }],
            });
            if (existingFeedback) {
                throw new Error("Email or phone number already exists.");
            }
            const feedback1 = yield collection.insertMany([...(_d = (feedback || [])) === null || _d === void 0 ? void 0 : _d.map(f => { return Object.assign(Object.assign({}, f), { createdAt: new Date() }); })]);
            return res.json({
                success: true,
                msg: "Feedback submitted successfully",
                data: { feedback1 },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
