"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserToken = getUserToken;
exports.signin = signin;
exports.login = login;
exports.auth = auth;
exports.passChange = passChange;
const jwt = require("jsonwebtoken");
const md5 = require("md5");
const bcrypt = require("bcryptjs");
const date_fns_1 = require("date-fns");
const auth_dto_1 = require("../dtos/auth.dto");
const db_1 = require("../models/db");
function getUserToken(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const token = jwt.sign({ id: md5(Math.random()), role: "user" }, process.env.JWT_SECRET, { expiresIn: process.env.JWT_EXPIRATION });
            const db = yield (0, db_1.connectToDatabase)();
            const Stat = db.collection("stat");
            const VisitorData = db.collection("visitordata");
            const result1 = yield Stat.findOneAndUpdate({ name: "visitors" }, { $inc: { noOfVisits: 1 } }, { returnDocument: "after", upsert: true });
            const result2 = yield VisitorData.findOneAndUpdate({ date: (0, date_fns_1.format)(new Date(), "dd-MM-yyyy") }, { $inc: { noOfVisits: 1 } }, { returnDocument: "after", upsert: true });
            return res.json({
                success: true,
                msg: "Token generated which will expires in 1 day",
                data: { token, role: "user" },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
function signin(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        try {
            const { password, email } = yield auth_dto_1.signinVS.validate(req.body);
            const db = yield (0, db_1.connectToDatabase)();
            const Login = db.collection("login");
            let salt = yield bcrypt.genSalt(10);
            let hpass = yield bcrypt.hash(password, salt);
            if (yield Login.findOne({ email })) {
                throw new Error("User already exists.");
            }
            let user = yield Login.insertOne({
                email,
                password: hpass,
                role: req.body.role,
            });
            const token = jwt.sign({ id: md5(Math.random()), email, role: (_a = req.body) === null || _a === void 0 ? void 0 : _a.role }, process.env.JWT_SECRET, { expiresIn: process.env.JWT_EXPIRATION });
            return res.json({
                success: true,
                msg: "Token generated which will expires in 1 day",
                data: { token, role: (_b = req.body) === null || _b === void 0 ? void 0 : _b.role },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
function login(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { password, email } = yield auth_dto_1.loginVS.validate(req.body);
            const db = yield (0, db_1.connectToDatabase)();
            const Login = db.collection("login");
            let user = yield Login.findOne({ email });
            if (!user) {
                throw new Error("User Does not exists");
            }
            const isMatch = yield bcrypt.compare(password, user === null || user === void 0 ? void 0 : user.password);
            if (!isMatch) {
                throw new Error("Wrong Password");
            }
            const token = jwt.sign({ id: md5(Math.random()), email: user.email, role: user === null || user === void 0 ? void 0 : user.role }, process.env.JWT_SECRET, { expiresIn: process.env.JWT_EXPIRATION });
            return res.json({
                success: true,
                msg: "Login successful",
                data: { token, user, role: user === null || user === void 0 ? void 0 : user.role },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
function auth(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f;
        try {
            if (!((_c = (_b = (_a = req === null || req === void 0 ? void 0 : req.headers) === null || _a === void 0 ? void 0 : _a.authorization) === null || _b === void 0 ? void 0 : _b.split(" ")) === null || _c === void 0 ? void 0 : _c[1])) {
                throw new Error("auth header is missing or error with auth header or wrong token");
            }
            let authData = jwt.verify((_f = (_e = (_d = req === null || req === void 0 ? void 0 : req.headers) === null || _d === void 0 ? void 0 : _d.authorization) === null || _e === void 0 ? void 0 : _e.split(" ")) === null || _f === void 0 ? void 0 : _f[1], process.env.JWT_SECRET);
            if (authData.role == "user") {
                return res.json({ success: true, data: {}, msg: "" });
            }
            let db = yield (0, db_1.connectToDatabase)();
            let Login = db.collection("login");
            let user = yield Login.findOne({ email: authData.email });
            return res.json({
                success: true,
                msg: "Auth Successful!!!",
                data: { user },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
function passChange(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f;
        try {
            if (!((_c = (_b = (_a = req === null || req === void 0 ? void 0 : req.headers) === null || _a === void 0 ? void 0 : _a.authorization) === null || _b === void 0 ? void 0 : _b.split(" ")) === null || _c === void 0 ? void 0 : _c[1])) {
                throw new Error("auth header is missing or error with auth header or wrong token");
            }
            let authData = jwt.verify((_f = (_e = (_d = req === null || req === void 0 ? void 0 : req.headers) === null || _d === void 0 ? void 0 : _d.authorization) === null || _e === void 0 ? void 0 : _e.split(" ")) === null || _f === void 0 ? void 0 : _f[1], process.env.JWT_SECRET);
            console.log(111, "passChange", req.body);
            if (authData.role != "admin") {
                throw new Error("Wrong Role!");
            }
            let db = yield (0, db_1.connectToDatabase)();
            let Login = db.collection("login");
            let user = yield Login.findOne({ email: authData.email });
            return res.json({
                success: true,
                msg: "Password Change Successful!!!",
                data: { user },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
