"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVisitationStat = getVisitationStat;
exports.logs = logs;
exports.getFeedback = getFeedback;
const jwt = require("jsonwebtoken");
const md5 = require("md5");
const admin_dto_1 = require("../dtos/admin.dto");
const db_1 = require("../models/db");
function getVisitationStat(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c;
        try {
            if (!((_c = (_b = (_a = req === null || req === void 0 ? void 0 : req.headers) === null || _a === void 0 ? void 0 : _a.authorization) === null || _b === void 0 ? void 0 : _b.split(" ")) === null || _c === void 0 ? void 0 : _c[1])) {
                throw new Error("auth header is missing or error with auth header or wrong token");
            }
            const db = yield (0, db_1.connectToDatabase)();
            const Stat = db.collection("stat");
            const VisitorData = db.collection("visitordata");
            const visitorStat = (yield Stat.find({ name: "visitors" }).toArray())[0];
            const dailyVisitorStat = yield VisitorData.find({})
                .sort({ date: -1 })
                .toArray();
            return res.json({
                success: true,
                msg: "Data successfully Retrived",
                data: { visitorStat, dailyVisitorStat },
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
function logs(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let { limit, skip, filter, sort, level } = yield admin_dto_1.logsVS.validate(Object.assign(Object.assign({}, req.query), { level: JSON.parse(req.query.level) }));
            sort = JSON.parse(sort);
            filter = filter ? filter : "";
            level = (level || []).filter(l => l);
            const db = yield (0, db_1.connectToDatabase)();
            const Logs = db.collection("logs");
            let query = {
                ["$and"]: []
            };
            if (((level === null || level === void 0 ? void 0 : level.length) || 0) > 0)
                query["$and"].push({ "level": { ['$in']: level } });
            const logs = yield Logs.find({
                $and: [
                    ...query["$and"],
                    {
                        $or: [
                            { message: { $regex: filter, $options: 'i' } },
                            { timestamp: { $regex: filter, $options: 'i' } }
                        ]
                    }
                ]
            })
                .sort(sort.reduce((acc, val) => { acc[val.field] = val.order; return acc; }, {}))
                .skip(skip)
                .limit(limit)
                .toArray();
            const totalSize = yield Logs.countDocuments({
                $and: [
                    ...query["$and"],
                    {
                        $or: [
                            { message: { $regex: filter, $options: 'i' } },
                            { timestamp: { $regex: filter, $options: 'i' } },
                        ]
                    }
                ]
            });
            res.status(200).json({
                success: true,
                data: { logs: logs, totalSize },
                msg: `Logs fetched with skip ${skip}, limit ${limit}`,
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
function getFeedback(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { limit, skip, filter, sort } = yield admin_dto_1.FeedbacksVS.validate(req.query);
            let sortMeta = JSON.parse(sort);
            let fil = filter ? filter : "";
            const db = yield (0, db_1.connectToDatabase)();
            const Logs = db.collection("feedback");
            const logs = yield Logs.find({
                $or: [
                    { name: { $regex: fil, $options: 'i' } },
                    { email: { $regex: fil, $options: 'i' } },
                    { phone: { $regex: fil, $options: 'i' } },
                    { msg: { $regex: fil, $options: 'i' } },
                    { createdAt: { $regex: fil, $options: 'i' } },
                ]
            })
                .sort(sortMeta.reduce((acc, val) => { acc[val.field] = val.order; return acc; }, {}))
                .skip(skip)
                .limit(limit)
                .toArray();
            const totalSize = yield Logs.countDocuments({
                $or: [
                    { name: { $regex: fil, $options: 'i' } },
                    { email: { $regex: fil, $options: 'i' } },
                    { phone: { $regex: fil, $options: 'i' } },
                    { msg: { $regex: fil, $options: 'i' } },
                    { createdAt: { $regex: fil, $options: 'i' } },
                ]
            });
            res.status(200).json({
                success: true,
                data: { feedbacks: logs, totalSize },
                msg: `Feedback fetched with skip ${skip}, limit ${limit}`,
            });
        }
        catch (error) {
            return next(error);
        }
    });
}
