"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.signinVS = exports.loginVS = void 0;
const yup = __importStar(require("yup"));
exports.loginVS = yup.object({
    email: yup
        .string()
        .transform((val) => (typeof val === "string" ? val.trim() : val))
        .email("Invalid email format")
        .required("Email is required"),
    password: yup
        .string()
        .transform((val) => (typeof val === "string" ? val.trim() : val))
        .required("Password is required"),
});
exports.signinVS = yup.object({
    email: yup
        .string()
        .transform((val) => (typeof val === "string" ? val.trim() : val))
        .email("Invalid email format")
        .required("Email is required"),
    password: yup
        .string()
        .transform((val) => (typeof val === "string" ? val.trim() : val))
        .required("Message is required"),
    role: yup
        .string()
        .transform((val) => (typeof val === "string" ? val.trim() : val))
});
const passChangeVS = yup.object({
    email: yup
        .string()
        .required("Email required!")
        .email("Invalid Email Format")
        .trim()
        .typeError("Email must be a strimg."),
    pass: yup
        .string()
        .required("Password required!")
        .min(12, "The Password should be at least 12 characters long")
        .matches(/[A-Z]/, "The Password must contain at least one uppercase letter.")
        .matches(/[a-z]/, "The Password must contain at least one lowercase letter.")
        .matches(/[@$!%*?&]/, "The Password must contain at least one special character.")
        .trim()
        .typeError("Password must be a string."),
    cpass: yup
        .string()
        .required("Confirmation Password required!")
        .min(12, "The Confirmation Password should be at least 12 characters long")
        .oneOf([yup.ref("pass")], "Passwords and confirm password must match.")
        .trim()
        .typeError("Confirmation Password must be a string."),
});
