"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const users_1 = require("../../handlers/users");
const postFeedbackMockReq = { body: { msg: "Great service!" }, };
const postFeedbackMockRes = { json: jest.fn(), };
const next = jest.fn();
describe("postFeedback", () => {
    it("should post feedback successfully and respond with the correct data", () => __awaiter(void 0, void 0, void 0, function* () {
        yield (0, users_1.postFeedback)(postFeedbackMockReq, postFeedbackMockRes, next);
        expect(postFeedbackMockRes.json).toHaveBeenCalledWith({
            success: true,
            msg: "Feedback submitted successfully",
            data: { msg: "Great service!" },
        });
        expect(next).not.toHaveBeenCalled();
    }));
    it("should call next() with an error if an exception occurs", () => __awaiter(void 0, void 0, void 0, function* () {
        const mockError = new Error("Something went wrong");
        postFeedbackMockRes.json = jest.fn().mockImplementationOnce(() => { throw mockError; });
        yield (0, users_1.postFeedback)(postFeedbackMockReq, postFeedbackMockRes, next);
        expect(next).toHaveBeenCalledWith(mockError);
    }));
});
